/*
 * Decompiled with CFR 0.152.
 */
package tools.tests.jinput;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Rumbler;

public class ControllerDetails {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            ControllerDetails.main_(stringArray);
        } else {
            ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
            Controller[] controllerArray = controllerEnvironment.getControllers();
            int n = 0;
            while (n < controllerArray.length) {
                if (n > 0) {
                    System.out.println(" ");
                }
                String string = controllerArray[n].getName();
                System.out.println("____________________________________________________________________________________");
                System.out.println("[" + n + "] " + string);
                System.out.println(" ");
                ControllerDetails.main_(new String[]{Integer.toString(n)});
                ++n;
            }
        }
    }

    public static void main_(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: ControllerDetails <index> [<fnm>]");
        } else {
            ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
            Controller[] controllerArray = controllerEnvironment.getControllers();
            if (controllerArray.length == 0) {
                System.out.println("No controllers found");
                System.exit(0);
            }
            int n = ControllerDetails.extractIndex(stringArray[0], controllerArray.length);
            PrintStream printStream = ControllerDetails.getPrintStream(stringArray);
            ControllerDetails.printDetails(controllerArray[n], printStream);
            if (printStream != System.out && printStream != System.err) {
                printStream.close();
            }
        }
    }

    private static int extractIndex(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Incorrect index format; using 0");
            System.exit(0);
        }
        if (n2 < 0 || n2 >= n) {
            System.out.println("Index not between 0 and " + (n - 1));
            System.exit(0);
        }
        return n2;
    }

    private static PrintStream getPrintStream(String[] stringArray) {
        if (stringArray.length < 2) {
            return System.out;
        }
        String string = stringArray[1];
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string));
            System.out.println("Writing to file: " + string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to open output file: " + string);
            printStream = System.out;
        }
        return printStream;
    }

    private static void printDetails(Controller controller, PrintStream printStream) {
        printStream.println(String.valueOf(controller.getName()) + ", " + controller.getType() + ", " + controller.getPortType());
        ControllerDetails.printComponents(controller.getComponents(), printStream);
        ControllerDetails.printRumblers(controller.getRumblers(), printStream);
        Controller[] controllerArray = controller.getControllers();
        if (controllerArray.length == 0) {
            printStream.println("No subcontrollers");
        } else {
            printStream.println("No. of subcontrollers: " + controllerArray.length);
            int n = 0;
            while (n < controllerArray.length) {
                printStream.println("---------------");
                printStream.println("Subcontroller: " + n);
                ControllerDetails.printDetails(controllerArray[n], printStream);
                ++n;
            }
        }
    }

    private static void printComponents(Component[] componentArray, PrintStream printStream) {
        if (componentArray.length == 0) {
            printStream.println("No Components");
        } else {
            printStream.println("Components: (" + componentArray.length + ")");
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                String string = component.getIdentifier().getClass().getName();
                printStream.println(String.valueOf(n) + ". " + string.substring(string.lastIndexOf(36) + 1) + ",\t" + component.getName() + ", " + ControllerDetails.getIdentifierName(component) + ", " + (component.isRelative() ? "relative" : "absolute") + ", " + (component.isAnalog() ? "analog" : "digital") + ", " + component.getDeadZone() + ", ");
                ++n;
            }
        }
    }

    private static String getIdentifierName(Component component) {
        Component.Identifier identifier = component.getIdentifier();
        if (identifier == Component.Identifier.Button.UNKNOWN) {
            return "button";
        }
        if (identifier == Component.Identifier.Key.UNKNOWN) {
            return "key";
        }
        return identifier.getName();
    }

    private static void printRumblers(Rumbler[] rumblerArray, PrintStream printStream) {
        if (rumblerArray.length == 0) {
            printStream.println("No Rumblers");
        } else {
            printStream.println("Rumblers: (" + rumblerArray.length + ")");
            int n = 0;
            while (n < rumblerArray.length) {
                Component.Identifier identifier = rumblerArray[n].getAxisIdentifier();
                printStream.print(String.valueOf(n) + ". " + rumblerArray[n].getAxisName() + " on axis; ");
                if (identifier == null) {
                    printStream.println("no name");
                } else {
                    printStream.println("name: " + identifier.getName());
                }
                ++n;
            }
        }
    }
}

